# -*- coding: utf-8 -*-
from core.utils.db import db
from datetime import datetime, timedelta, timezone
import json

class SavedSessionList(db.Model):
    __tablename__ = 'saved_session_lists'
    
    # La clave de sesión que se guarda en la cookie del navegador (UUID)
    id = db.Column(db.String(36), primary_key=True) 
    
    # La lista de IDs guardada como JSON string
    data = db.Column(db.Text, nullable=False) 
    
    # Para la limpieza de la DB (opcional)
    created_at = db.Column(db.DateTime(timezone=True), default=lambda: datetime.now(timezone.utc))
    expires_at = db.Column(db.DateTime(timezone=True), default=lambda: datetime.now(timezone.utc) + timedelta(hours=1))

    def get_ids(self):
        """Retorna la lista de IDs deserializada."""
        return json.loads(self.data)