# -*- coding: utf-8 -*-
from werkzeug.security import generate_password_hash
from flask_login import UserMixin
from core.utils.db import db

class User(UserMixin,db.Model):
    id = db.Column(db.Integer, primary_key=True)
    email = db.Column(db.String(100))
    name = db.Column(db.String(100))
    lastname = db.Column(db.String(100))
    image_id = image_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    image = db.relationship('Blob', foreign_keys=[image_id], lazy='joined')
    birthdate = db.Column(db.Date)
    phone = db.Column(db.String(100))
    mobile = db.Column(db.String(100))
    address = db.Column(db.String(100))
    city = db.Column(db.String(100))
    state = db.Column(db.String(100))
    country = db.Column(db.String(100))
    zipcode = db.Column(db.String(100))
    description = db.Column(db.Text)
    _reset_token = db.Column(db.String(255))
    _token_expiration = db.Column(db.DateTime)
    _password_hash = db.Column(db.String(255))
    usergroup_id = db.Column(db.Integer, db.ForeignKey('usergroup.id'))
    usergroup = db.relationship('Usergroup', backref='users')
    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }

    def __repr__(self) -> str:
        return f"{self.email}"
    
    def set_password(self, password):
        self._password_hash = generate_password_hash(password)


def get_fields_form():
    from core.utils.packages import application
    clazzes = application.getAllUsergroups()
    options = [{"label": usergroup.name, "value": usergroup.id} for usergroup in clazzes if usergroup.id != 1]
    fields = {
            "description": {
                "id": "description", 
                "type": "Text", 
                "maxlength": "", 
                "label": "Descripción", 
                "input": "areatext",
                "class":"",
                "name": "description",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "zipcode": {
                "id": "zipcode", 
                "type": "String", 
                "maxlength": "", 
                "label": "ZIP", 
                "input": "text",
                "class":"",
                "name": "zipcode",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "country": {
                "id": "country", 
                "type": "String", 
                "maxlength": "", 
                "label": "País", 
                "input": "text",
                "class":"",
                "name": "country",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "state": {
                "id": "state", 
                "type": "String", 
                "maxlength": "", 
                "label": "Estado / Provincia / Región", 
                "input": "text",
                "class":"",
                "name": "state",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "city": {
                "id": "city", 
                "type": "String", 
                "maxlength": "", 
                "label": "Ciudad", 
                "input": "text",
                "class":"",
                "name": "city",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "address": {
                "id": "address", 
                "type": "String", 
                "maxlength": "", 
                "label": "Dirección", 
                "input": "text",
                "class":"",
                "name": "address",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "mobile": {
                "id": "mobile", 
                "type": "String", 
                "maxlength": "", 
                "label": "Teléfono Móvil", 
                "input": "text",
                "class":"",
                "name": "mobile",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "phone": {
                "id": "phone", 
                "type": "String", 
                "maxlength": "", 
                "label": "Teléfono", 
                "input": "text",
                "class":"",
                "name": "phone",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "birthdate": {
                "id": "birthdate", 
                "type": "Date", 
                "maxlength": "", 
                "label": "Fecha de nacimiento", 
                "input": "date",
                "class":"",
                "name": "birthdate",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": True,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "image": {
                "id": "image", 
                "type": "blob", 
                "maxlength": "", 
                "label": "Imagen de Perfil", 
                "input": "image",
                "class":"",
                "name": "image",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "id": {
                "id": "id", 
                "type": "Integer", 
                "maxlength": "", 
                "label": "Id", 
                "input": "integer",
                "class":"",
                "name": "id",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": True,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "name": {
                "id": "name", 
                "type": "String", 
                "maxlength": "100", 
                "label": "Nombre", 
                "input": "text",
                "class":"",
                "name": "name",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "lastname": {
                "id": "lastname", 
                "type": "String", 
                "maxlength": "100", 
                "label": "Apellido", 
                "input": "text",
                "class":"",
                "name": "lastname",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "email": {
                "id": "email", 
                "type": "String", 
                "maxlength": "100", 
                "label": "Usuario", 
                "input": "text",
                "class":"",
                "name": "email",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "select_options": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            },
            "usergroup_id": {
                "id": "usergroup_id", 
                "type": "Integer", 
                "maxlength": "", 
                "label": "Tipo de Usuario", 
                "input": "select",
                "class":"",
                "select_options":options,
                "name": "usergroup_id",
                "sort": None,
                "publicBlob": False,
                "extraclass": None,
                "required": False,
                "hidden": False,
                "readOnly": False,
                "hasManyValues": False,
                "connected_table": None,
                "defaultValue": None,
                "calculate_file": None,
                "calculate_function": None
            }
        }
    return fields

def get_fields():
    from core.utils.packages import application
    clazzes = application.getAllUsergroups()
    options = [{"label": usergroup.name, "value": usergroup.id} for usergroup in clazzes if usergroup.id != 1]
    fields = {
        "GeneralInfo":{
            "class":"col-sm-4",
            "title":"Identificacion",
            "fields":{
                "id": {
                    "id": "id", 
                    "type": "Integer", 
                    "maxlength": "", 
                    "label": "Id", 
                    "input": "integer",
                    "class":""
                },
                "name": {
                    "id": "name", 
                    "type": "String", 
                    "maxlength": "100", 
                    "label": "Nombre", 
                    "input": "text",
                    "class":""
                },
                "lastname": {
                    "id": "lastname", 
                    "type": "String", 
                    "maxlength": "100", 
                    "label": "Apellido", 
                    "input": "text",
                    "class":""
                },
                "email": {
                    "id": "email", 
                    "type": "String", 
                    "maxlength": "100", 
                    "label": "Usuario", 
                    "input": "text",
                    "class":""
                },
                "usergroup_id": {
                    "id": "usergroup_id", 
                    "type": "Integer", 
                    "maxlength": "", 
                    "label": "Tipo de Usuario", 
                    "input": "select",
                    "class":"",
                    "options":options
                }
            }
        }
    }
    return fields