# -*- coding: utf-8 -*- 
from core.models.develop.field import Field, get_fields, get_fields_form

from core.utils.packages import application, session
from flask import Blueprint, render_template, request, flash, redirect, url_for, current_app
from core.utils.db import db
from werkzeug.utils import secure_filename
from flask_login import login_required
import os
from core.utils.packages.engine import traceError

classname = "field"
Record = Field

blueprintname = Blueprint("field", __name__)

@blueprintname.route(f'/develop/{classname}/new/', methods=["GET","POST"])
@traceError
@login_required
def create_record():
    class_names = application.list_class_names()
    parent = request.args.get('parent')
    containers = get_fields(parent)
    fields = get_fields_form()
    backlink = request.args.get("backlink")
    if request.method == "GET":
        return render_template("backend/base/new_base.html", containers=containers,classname=classname, class_names=class_names,backlink=backlink)
    elif request.method == "POST":
        new_institution = Record()
        session.saveForm(new_institution,fields)
        db.session.add(new_institution)
        db.session.commit()

        return redirect(url_for('.view_record', record_id=new_institution.id,classname=classname, class_names=class_names,backlink=backlink))
    
@blueprintname.route(f'/develop/{classname}/<int:record_id>')
@traceError
@login_required
def view_record(record_id):
    class_names = application.list_class_names()
    institution = Record.query.get_or_404(record_id)
    #parent = institution.container_id
    containers = get_fields()
    backlink = request.args.get("backlink")
    return render_template('backend/base/view_field.html', institution=institution, containers=containers,classname=classname, class_names=class_names,backlink=backlink)

@blueprintname.route(f'/develop/{classname}/<int:record_id>/edit/', methods=['GET', 'POST'])
@traceError
@login_required
def edit_record(record_id):
    class_names = application.list_class_names()
    institution = Record.query.get_or_404(record_id)
    #parent = institution.container_id
    containers = get_fields()
    fields = get_fields_form()
    backlink = request.args.get("backlink")
    if request.method == 'POST':
        session.saveForm(institution,fields)
        db.session.commit()
        flash('Campo ha sido actualizado exitosamente.', 'success')
        return render_template('backend/base/edit_base.html', institution=institution, containers=containers,classname=classname, class_names=class_names,backlink=backlink)
    return render_template('backend/base/edit_base.html', institution=institution,containers=containers,classname=classname, class_names=class_names,backlink=backlink)

@blueprintname.route(f'/develop/{classname}/<int:record_id>/delete/', methods=['POST'])
@traceError
@login_required
def delete_record(record_id):
    class_names = application.list_class_names()
    institution = Record.query.get_or_404(record_id)
    backlink = request.args.get("backlink")
    db.session.delete(institution)
    db.session.commit()
    flash('Campo ha sido eliminado exitosamente.', 'success')
    return redirect(url_for('.list_record'))  # Asumiendo que existe una ruta para listar instituciones

@blueprintname.route(f'/develop/{classname}/all/')
@traceError
@login_required
def list_record():
    class_names = application.list_class_names()
    institutions = Record.query.all()  # Consulta todas las instituciones
    backlink = request.args.get("backlink")
    return render_template('backend/base/list_base.html', institutions=institutions,classname=classname, class_names=class_names,backlink=backlink)
