"""Actualiza clases

Revision ID: 0be293c7810f
Revises: f2a8011695b6
Create Date: 2025-11-12 17:45:09.655562

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = '0be293c7810f'
down_revision = 'f2a8011695b6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('authorlibrary')
    with op.batch_alter_table('field', schema=None) as batch_op:
        batch_op.add_column(sa.Column('allowHtml', sa.Boolean(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('field', schema=None) as batch_op:
        batch_op.drop_column('allowHtml')

    op.create_table('authorlibrary',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('alias', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('apprenticeOf', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('authorCode', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('bornYear', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('collectiveName', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('consecated', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('country', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('deceased', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('firstname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('fullname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('gender', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('lastname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('biography', mysql.TEXT(), nullable=True),
    sa.Column('mainPicture_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('objectQty', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('observation', mysql.TEXT(), nullable=True),
    sa.Column('placeDeceased', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('placeBirth', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('disciple', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('tags', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('atelier', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('textsearch', mysql.TEXT(), nullable=True),
    sa.Column('type', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('workshop', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_authorlibrary_createdby_id_user')),
    sa.ForeignKeyConstraint(['mainPicture_id'], ['blob.id'], name=op.f('fk_authorlibrary_mainPicture_id_blob')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_authorlibrary_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    # ### end Alembic commands ###
