"""Actualizacion de Base de datos hecha por vane.valverdesantos@gmail.com a las: 2025-11-04 02:20:05

Revision ID: 0f2c3ad1d183
Revises: e5bf46c2f77f
Create Date: 2025-11-04 02:20:28.801487

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0f2c3ad1d183'
down_revision = 'e5bf46c2f77f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('object_material', schema=None) as batch_op:
        batch_op.create_foreign_key(batch_op.f('fk_object_material_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_objectgroup', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'))
        batch_op.create_foreign_key(batch_op.f('fk_object_objectgroup_object_id_object'), 'object', ['object_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'), 'objectgroup', ['objectgroup_id'], ['id'])

    with op.batch_alter_table('object_styleperiod', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'))
        batch_op.create_foreign_key(batch_op.f('fk_object_styleperiod_object_id_object'), 'object', ['object_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'), 'styleperiod', ['styleperiod_id'], ['id'])

    with op.batch_alter_table('object_tag', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_tag_tag_id_tag'))
        batch_op.create_foreign_key(batch_op.f('fk_object_tag_tag_id_tag'), 'tag', ['tag_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_tag_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_technique', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_technique_technique_id_technique'))
        batch_op.create_foreign_key(batch_op.f('fk_object_technique_technique_id_technique'), 'technique', ['technique_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_technique_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_type', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_type_type_id_type'))
        batch_op.create_foreign_key(batch_op.f('fk_object_type_object_id_object'), 'object', ['object_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_type_type_id_type'), 'type', ['type_id'], ['id'])

    with op.batch_alter_table('objectgroup', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_objectgroup_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_objectgroup_image_id_blob'))
        batch_op.drop_index(batch_op.f('fk_objectgroup_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_objectgroup_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_objectgroup_image_id_blob'), 'blob', ['image_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_objectgroup_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('publication', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_publication_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_publication_group_id_objectgroup'))
        batch_op.drop_index(batch_op.f('fk_publication_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_publication_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_publication_group_id_objectgroup'), 'objectgroup', ['group_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_publication_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('relevant', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_relevant_clazz_id_clazz'))
        batch_op.drop_index(batch_op.f('fk_relevant_usergroup_id_usergroup'))
        batch_op.create_foreign_key(batch_op.f('fk_relevant_usergroup_id_usergroup'), 'usergroup', ['usergroup_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_relevant_clazz_id_clazz'), 'clazz', ['clazz_id'], ['id'])

    with op.batch_alter_table('reproductionright', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_reproductionright_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_reproductionright_creator_id_creator'))
        batch_op.drop_index(batch_op.f('fk_reproductionright_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_reproductionright_creator_id_creator'), 'creator', ['creator_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_reproductionright_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_reproductionright_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('request_log', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_request_log_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_request_log_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_request_log_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_request_log_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('styleperiod', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_styleperiod_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_styleperiod_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_styleperiod_parent_id_styleperiod'))
        batch_op.create_foreign_key(batch_op.f('fk_styleperiod_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_styleperiod_parent_id_styleperiod'), 'styleperiod', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_styleperiod_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('tag', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_tag_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_tag_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_tag_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_tag_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('technique', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_technique_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_technique_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_technique_parent_id_technique'))
        batch_op.create_foreign_key(batch_op.f('fk_technique_parent_id_technique'), 'technique', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_technique_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_technique_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('theme', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_theme_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_theme_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_theme_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_theme_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('type', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_type_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_type_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_type_parent_id_type'))
        batch_op.create_foreign_key(batch_op.f('fk_type_parent_id_type'), 'type', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_type_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_type_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('user', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_user_image_id_blob'))
        batch_op.drop_index(batch_op.f('fk_user_usergroup_id_usergroup'))
        batch_op.create_foreign_key(batch_op.f('fk_user_image_id_blob'), 'blob', ['image_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_user_usergroup_id_usergroup'), 'usergroup', ['usergroup_id'], ['id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('user', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_user_usergroup_id_usergroup'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_user_image_id_blob'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_user_usergroup_id_usergroup'), ['usergroup_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_user_image_id_blob'), ['image_id'], unique=False)

    with op.batch_alter_table('type', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_type_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_type_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_type_parent_id_type'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_type_parent_id_type'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_type_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_type_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('theme', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_theme_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_theme_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_theme_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_theme_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('technique', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_technique_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_technique_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_technique_parent_id_technique'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_technique_parent_id_technique'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_technique_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_technique_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('tag', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_tag_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_tag_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_tag_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_tag_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('styleperiod', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_styleperiod_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_styleperiod_parent_id_styleperiod'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_styleperiod_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_styleperiod_parent_id_styleperiod'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_styleperiod_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_styleperiod_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('request_log', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_request_log_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_request_log_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_request_log_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_request_log_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('reproductionright', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_reproductionright_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_reproductionright_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_reproductionright_creator_id_creator'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_reproductionright_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_reproductionright_creator_id_creator'), ['creator_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_reproductionright_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('relevant', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_relevant_clazz_id_clazz'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_relevant_usergroup_id_usergroup'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_relevant_usergroup_id_usergroup'), ['usergroup_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_relevant_clazz_id_clazz'), ['clazz_id'], unique=False)

    with op.batch_alter_table('publication', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_publication_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_publication_group_id_objectgroup'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_publication_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_publication_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_publication_group_id_objectgroup'), ['group_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_publication_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('objectgroup', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_objectgroup_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_objectgroup_image_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_objectgroup_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_objectgroup_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_objectgroup_image_id_blob'), ['image_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_objectgroup_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('object_type', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_type_type_id_type'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_type_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_type_type_id_type'), ['type_id'], unique=False)

    with op.batch_alter_table('object_technique', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_technique_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_technique_technique_id_technique'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_technique_technique_id_technique'), ['technique_id'], unique=False)

    with op.batch_alter_table('object_tag', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_tag_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_tag_tag_id_tag'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_tag_tag_id_tag'), ['tag_id'], unique=False)

    with op.batch_alter_table('object_styleperiod', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_styleperiod_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'), ['styleperiod_id'], unique=False)

    with op.batch_alter_table('object_objectgroup', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_objectgroup_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'), ['objectgroup_id'], unique=False)

    with op.batch_alter_table('object_material', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_material_object_id_object'), type_='foreignkey')

    # ### end Alembic commands ###
