"""Intenta migrar

Revision ID: b5e280e2c308
Revises: 
Create Date: 2025-11-03 20:08:33.742543

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b5e280e2c308'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('category', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_category_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_category_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_category_parent_id_category'))
        batch_op.create_foreign_key(batch_op.f('fk_category_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_category_parent_id_category'), 'category', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_category_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('cocreator', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_cocreator_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_cocreator_creator_id_creator'))
        batch_op.drop_index(batch_op.f('fk_cocreator_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_cocreator_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_cocreator_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_cocreator_creator_id_creator'), 'creator', ['creator_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_cocreator_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_cocreator_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')

    with op.batch_alter_table('collectionlist', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_collectionlist_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_collectionlist_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_collectionlist_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_collectionlist_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('container', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_container_clazz_id_clazz'))
        batch_op.create_foreign_key(batch_op.f('fk_container_clazz_id_clazz'), 'clazz', ['clazz_id'], ['id'], ondelete='CASCADE')

    with op.batch_alter_table('creator', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_creator_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_creator_mainPicture_id_blob'))
        batch_op.drop_index(batch_op.f('fk_creator_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_creator_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_creator_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_creator_mainPicture_id_blob'), 'blob', ['mainPicture_id'], ['id'])

    with op.batch_alter_table('creatordocument', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_creatordocument_blob_id_blob'))
        batch_op.drop_index(batch_op.f('fk_creatordocument_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_creatordocument_creator_id_creator'))
        batch_op.drop_index(batch_op.f('fk_creatordocument_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_creatordocument_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_creatordocument_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_creatordocument_creator_id_creator'), 'creator', ['creator_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_creatordocument_blob_id_blob'), 'blob', ['blob_id'], ['id'])

    with op.batch_alter_table('cultureethnia', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_cultureethnia_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_cultureethnia_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_cultureethnia_parent_id_cultureethnia'))
        batch_op.create_foreign_key(batch_op.f('fk_cultureethnia_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_cultureethnia_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_cultureethnia_parent_id_cultureethnia'), 'cultureethnia', ['parent_id'], ['id'], ondelete='SET NULL')

    with op.batch_alter_table('customperiod', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_customperiod_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_customperiod_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_customperiod_parent_id_customperiod'))
        batch_op.create_foreign_key(batch_op.f('fk_customperiod_parent_id_customperiod'), 'customperiod', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_customperiod_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_customperiod_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('documentobject', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_documentobject_blob_id_blob'))
        batch_op.drop_index(batch_op.f('fk_documentobject_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_documentobject_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_documentobject_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_documentobject_blob_id_blob'), 'blob', ['blob_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_documentobject_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_documentobject_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_documentobject_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('field', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_field_clazz_id_clazz'))
        batch_op.create_foreign_key(batch_op.f('fk_field_clazz_id_clazz'), 'clazz', ['clazz_id'], ['id'], ondelete='CASCADE')

    with op.batch_alter_table('image', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_image_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_image_image_id_blob'))
        batch_op.drop_index(batch_op.f('fk_image_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_image_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_image_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_image_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_image_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_image_image_id_blob'), 'blob', ['image_id'], ['id'])

    with op.batch_alter_table('intervention', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_intervention_attachmentAdditional_id_blob'))
        batch_op.drop_index(batch_op.f('fk_intervention_attachmentOther_id_blob'))
        batch_op.drop_index(batch_op.f('fk_intervention_attachment_id_blob'))
        batch_op.drop_index(batch_op.f('fk_intervention_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_intervention_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_intervention_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_intervention_attachmentAdditional_id_blob'), 'blob', ['attachmentAdditional_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_intervention_attachment_id_blob'), 'blob', ['attachment_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_intervention_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_intervention_attachmentOther_id_blob'), 'blob', ['attachmentOther_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_intervention_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_intervention_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('itineranthistory', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_itineranthistory_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_itineranthistory_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_itineranthistory_relation_id_objectgroup'))
        batch_op.create_foreign_key(batch_op.f('fk_itineranthistory_relation_id_objectgroup'), 'objectgroup', ['relation_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_itineranthistory_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_itineranthistory_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('location', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_location_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_location_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_location_parent_id_location'))
        batch_op.create_foreign_key(batch_op.f('fk_location_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_location_parent_id_location'), 'location', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_location_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('locationlog', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_locationlog_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_locationlog_location_id_location'))
        batch_op.drop_index(batch_op.f('fk_locationlog_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_locationlog_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_locationlog_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_locationlog_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_locationlog_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_locationlog_location_id_location'), 'location', ['location_id'], ['id'], ondelete='SET NULL')

    with op.batch_alter_table('material', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_material_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_material_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_material_parent_id_material'))
        batch_op.create_foreign_key(batch_op.f('fk_material_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_material_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_material_parent_id_material'), 'material', ['parent_id'], ['id'], ondelete='SET NULL')

    with op.batch_alter_table('measurement', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_measurement_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_measurement_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_measurement_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_measurement_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_measurement_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_measurement_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('note', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_note_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_note_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_note_object_id_object'))
        batch_op.create_foreign_key(batch_op.f('fk_note_object_id_object'), 'object', ['object_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_note_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_note_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('object', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_collection_id_collectionlist'))
        batch_op.drop_index(batch_op.f('fk_object_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_object_creator_id_creator'))
        batch_op.drop_index(batch_op.f('fk_object_featuredImage_id_blob'))
        batch_op.drop_index(batch_op.f('fk_object_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_object_theme_id_theme'))
        batch_op.create_foreign_key(batch_op.f('fk_object_theme_id_theme'), 'theme', ['theme_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_object_featuredImage_id_blob'), 'blob', ['featuredImage_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_collection_id_collectionlist'), 'collectionlist', ['collection_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_object_creator_id_creator'), 'creator', ['creator_id'], ['id'], ondelete='SET NULL')

    with op.batch_alter_table('object_category', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_category_category_id_category'))
        batch_op.create_foreign_key(batch_op.f('fk_object_category_category_id_category'), 'category', ['category_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_category_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_cultureethnia', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_cultureethnia_cultureethnia_id_cultureethnia'))
        batch_op.create_foreign_key(batch_op.f('fk_object_cultureethnia_object_id_object'), 'object', ['object_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_cultureethnia_cultureethnia_id_cultureethnia'), 'cultureethnia', ['cultureethnia_id'], ['id'])

    with op.batch_alter_table('object_customperiod', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_customperiod_customperiod_id_customperiod'))
        batch_op.create_foreign_key(batch_op.f('fk_object_customperiod_customperiod_id_customperiod'), 'customperiod', ['customperiod_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_customperiod_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_material', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_material_material_id_material'))
        batch_op.create_foreign_key(batch_op.f('fk_object_material_material_id_material'), 'material', ['material_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_material_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_objectgroup', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'))
        batch_op.create_foreign_key(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'), 'objectgroup', ['objectgroup_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_objectgroup_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_styleperiod', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'))
        batch_op.create_foreign_key(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'), 'styleperiod', ['styleperiod_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_styleperiod_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_tag', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_tag_tag_id_tag'))
        batch_op.create_foreign_key(batch_op.f('fk_object_tag_tag_id_tag'), 'tag', ['tag_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_tag_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('object_technique', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_technique_technique_id_technique'))
        batch_op.create_foreign_key(batch_op.f('fk_object_technique_object_id_object'), 'object', ['object_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_technique_technique_id_technique'), 'technique', ['technique_id'], ['id'])

    with op.batch_alter_table('object_type', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_object_type_type_id_type'))
        batch_op.create_foreign_key(batch_op.f('fk_object_type_type_id_type'), 'type', ['type_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_object_type_object_id_object'), 'object', ['object_id'], ['id'])

    with op.batch_alter_table('objectgroup', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_objectgroup_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_objectgroup_image_id_blob'))
        batch_op.drop_index(batch_op.f('fk_objectgroup_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_objectgroup_image_id_blob'), 'blob', ['image_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_objectgroup_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_objectgroup_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('publication', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_publication_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_publication_group_id_objectgroup'))
        batch_op.drop_index(batch_op.f('fk_publication_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_publication_group_id_objectgroup'), 'objectgroup', ['group_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_publication_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_publication_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('relevant', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_relevant_clazz_id_clazz'))
        batch_op.drop_index(batch_op.f('fk_relevant_usergroup_id_usergroup'))
        batch_op.create_foreign_key(batch_op.f('fk_relevant_clazz_id_clazz'), 'clazz', ['clazz_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_relevant_usergroup_id_usergroup'), 'usergroup', ['usergroup_id'], ['id'])

    with op.batch_alter_table('reproductionright', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_reproductionright_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_reproductionright_creator_id_creator'))
        batch_op.drop_index(batch_op.f('fk_reproductionright_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_reproductionright_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_reproductionright_creator_id_creator'), 'creator', ['creator_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_reproductionright_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('request_log', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_request_log_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_request_log_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_request_log_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_request_log_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('styleperiod', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_styleperiod_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_styleperiod_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_styleperiod_parent_id_styleperiod'))
        batch_op.create_foreign_key(batch_op.f('fk_styleperiod_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_styleperiod_parent_id_styleperiod'), 'styleperiod', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_styleperiod_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('tag', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_tag_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_tag_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_tag_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_tag_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('technique', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_technique_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_technique_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_technique_parent_id_technique'))
        batch_op.create_foreign_key(batch_op.f('fk_technique_parent_id_technique'), 'technique', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_technique_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_technique_createdby_id_user'), 'user', ['createdby_id'], ['id'])

    with op.batch_alter_table('theme', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_theme_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_theme_modifiedby_id_user'))
        batch_op.create_foreign_key(batch_op.f('fk_theme_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_theme_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('type', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_type_createdby_id_user'))
        batch_op.drop_index(batch_op.f('fk_type_modifiedby_id_user'))
        batch_op.drop_index(batch_op.f('fk_type_parent_id_type'))
        batch_op.create_foreign_key(batch_op.f('fk_type_parent_id_type'), 'type', ['parent_id'], ['id'], ondelete='SET NULL')
        batch_op.create_foreign_key(batch_op.f('fk_type_createdby_id_user'), 'user', ['createdby_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_type_modifiedby_id_user'), 'user', ['modifiedby_id'], ['id'])

    with op.batch_alter_table('user', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('fk_user_image_id_blob'))
        batch_op.drop_index(batch_op.f('fk_user_usergroup_id_usergroup'))
        batch_op.create_foreign_key(batch_op.f('fk_user_usergroup_id_usergroup'), 'usergroup', ['usergroup_id'], ['id'])
        batch_op.create_foreign_key(batch_op.f('fk_user_image_id_blob'), 'blob', ['image_id'], ['id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('user', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_user_image_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_user_usergroup_id_usergroup'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_user_usergroup_id_usergroup'), ['usergroup_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_user_image_id_blob'), ['image_id'], unique=False)

    with op.batch_alter_table('type', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_type_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_type_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_type_parent_id_type'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_type_parent_id_type'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_type_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_type_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('theme', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_theme_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_theme_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_theme_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_theme_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('technique', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_technique_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_technique_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_technique_parent_id_technique'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_technique_parent_id_technique'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_technique_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_technique_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('tag', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_tag_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_tag_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_tag_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_tag_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('styleperiod', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_styleperiod_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_styleperiod_parent_id_styleperiod'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_styleperiod_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_styleperiod_parent_id_styleperiod'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_styleperiod_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_styleperiod_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('request_log', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_request_log_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_request_log_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_request_log_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_request_log_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('reproductionright', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_reproductionright_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_reproductionright_creator_id_creator'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_reproductionright_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_reproductionright_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_reproductionright_creator_id_creator'), ['creator_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_reproductionright_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('relevant', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_relevant_usergroup_id_usergroup'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_relevant_clazz_id_clazz'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_relevant_usergroup_id_usergroup'), ['usergroup_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_relevant_clazz_id_clazz'), ['clazz_id'], unique=False)

    with op.batch_alter_table('publication', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_publication_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_publication_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_publication_group_id_objectgroup'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_publication_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_publication_group_id_objectgroup'), ['group_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_publication_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('objectgroup', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_objectgroup_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_objectgroup_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_objectgroup_image_id_blob'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_objectgroup_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_objectgroup_image_id_blob'), ['image_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_objectgroup_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('object_type', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_type_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_type_type_id_type'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_type_type_id_type'), ['type_id'], unique=False)

    with op.batch_alter_table('object_technique', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_technique_technique_id_technique'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_technique_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_technique_technique_id_technique'), ['technique_id'], unique=False)

    with op.batch_alter_table('object_tag', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_tag_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_tag_tag_id_tag'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_tag_tag_id_tag'), ['tag_id'], unique=False)

    with op.batch_alter_table('object_styleperiod', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_styleperiod_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_styleperiod_styleperiod_id_styleperiod'), ['styleperiod_id'], unique=False)

    with op.batch_alter_table('object_objectgroup', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_objectgroup_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_objectgroup_objectgroup_id_objectgroup'), ['objectgroup_id'], unique=False)

    with op.batch_alter_table('object_material', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_material_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_material_material_id_material'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_material_material_id_material'), ['material_id'], unique=False)

    with op.batch_alter_table('object_customperiod', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_customperiod_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_customperiod_customperiod_id_customperiod'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_customperiod_customperiod_id_customperiod'), ['customperiod_id'], unique=False)

    with op.batch_alter_table('object_cultureethnia', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_cultureethnia_cultureethnia_id_cultureethnia'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_cultureethnia_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_cultureethnia_cultureethnia_id_cultureethnia'), ['cultureethnia_id'], unique=False)

    with op.batch_alter_table('object_category', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_category_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_category_category_id_category'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_category_category_id_category'), ['category_id'], unique=False)

    with op.batch_alter_table('object', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_object_creator_id_creator'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_collection_id_collectionlist'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_featuredImage_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_object_theme_id_theme'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_object_theme_id_theme'), ['theme_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_object_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_object_featuredImage_id_blob'), ['featuredImage_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_object_creator_id_creator'), ['creator_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_object_createdby_id_user'), ['createdby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_object_collection_id_collectionlist'), ['collection_id'], unique=False)

    with op.batch_alter_table('note', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_note_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_note_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_note_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_note_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_note_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_note_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('measurement', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_measurement_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_measurement_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_measurement_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_measurement_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_measurement_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_measurement_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('material', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_material_parent_id_material'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_material_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_material_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_material_parent_id_material'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_material_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_material_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('locationlog', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_locationlog_location_id_location'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_locationlog_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_locationlog_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_locationlog_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_locationlog_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_locationlog_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_locationlog_location_id_location'), ['location_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_locationlog_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('location', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_location_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_location_parent_id_location'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_location_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_location_parent_id_location'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_location_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_location_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('itineranthistory', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_itineranthistory_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_itineranthistory_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_itineranthistory_relation_id_objectgroup'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_itineranthistory_relation_id_objectgroup'), ['relation_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_itineranthistory_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_itineranthistory_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('intervention', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_intervention_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_intervention_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_intervention_attachmentOther_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_intervention_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_intervention_attachment_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_intervention_attachmentAdditional_id_blob'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_intervention_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_intervention_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_intervention_createdby_id_user'), ['createdby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_intervention_attachment_id_blob'), ['attachment_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_intervention_attachmentOther_id_blob'), ['attachmentOther_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_intervention_attachmentAdditional_id_blob'), ['attachmentAdditional_id'], unique=False)

    with op.batch_alter_table('image', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_image_image_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_image_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_image_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_image_object_id_object'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_image_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_image_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_image_image_id_blob'), ['image_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_image_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('field', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_field_clazz_id_clazz'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_field_clazz_id_clazz'), ['clazz_id'], unique=False)

    with op.batch_alter_table('documentobject', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_documentobject_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_documentobject_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_documentobject_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_documentobject_blob_id_blob'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_documentobject_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_documentobject_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_documentobject_createdby_id_user'), ['createdby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_documentobject_blob_id_blob'), ['blob_id'], unique=False)

    with op.batch_alter_table('customperiod', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_customperiod_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_customperiod_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_customperiod_parent_id_customperiod'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_customperiod_parent_id_customperiod'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_customperiod_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_customperiod_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('cultureethnia', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_cultureethnia_parent_id_cultureethnia'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_cultureethnia_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_cultureethnia_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_cultureethnia_parent_id_cultureethnia'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_cultureethnia_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_cultureethnia_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('creatordocument', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_creatordocument_blob_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_creatordocument_creator_id_creator'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_creatordocument_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_creatordocument_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_creatordocument_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_creatordocument_creator_id_creator'), ['creator_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_creatordocument_createdby_id_user'), ['createdby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_creatordocument_blob_id_blob'), ['blob_id'], unique=False)

    with op.batch_alter_table('creator', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_creator_mainPicture_id_blob'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_creator_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_creator_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_creator_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_creator_mainPicture_id_blob'), ['mainPicture_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_creator_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('container', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_container_clazz_id_clazz'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_container_clazz_id_clazz'), ['clazz_id'], unique=False)

    with op.batch_alter_table('collectionlist', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_collectionlist_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_collectionlist_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_collectionlist_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_collectionlist_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('cocreator', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_cocreator_object_id_object'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_cocreator_modifiedby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_cocreator_creator_id_creator'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_cocreator_createdby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_cocreator_object_id_object'), ['object_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_cocreator_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_cocreator_creator_id_creator'), ['creator_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_cocreator_createdby_id_user'), ['createdby_id'], unique=False)

    with op.batch_alter_table('category', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_category_createdby_id_user'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_category_parent_id_category'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_category_modifiedby_id_user'), type_='foreignkey')
        batch_op.create_index(batch_op.f('fk_category_parent_id_category'), ['parent_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_category_modifiedby_id_user'), ['modifiedby_id'], unique=False)
        batch_op.create_index(batch_op.f('fk_category_createdby_id_user'), ['createdby_id'], unique=False)

    # ### end Alembic commands ###
