"""Actualiza clases

Revision ID: f2a8011695b6
Revises: 7b7aebfe5a5b
Create Date: 2025-11-12 17:42:41.792316

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = 'f2a8011695b6'
down_revision = '7b7aebfe5a5b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('image')
    op.drop_table('intervention')
    op.drop_table('tag')
    op.drop_table('object_technique')
    op.drop_table('creator')
    op.drop_table('note')
    op.drop_table('object_category')
    op.drop_table('reproductionright')
    op.drop_table('measurement')
    op.drop_table('object_material')
    op.drop_table('material')
    op.drop_table('category')
    op.drop_table('object_styleperiod')
    op.drop_table('documentobject')
    op.drop_table('object')
    op.drop_table('locationlog')
    op.drop_table('cultureethnia')
    op.drop_table('objectgroup')
    op.drop_table('collectionlist')
    op.drop_table('technique')
    op.drop_table('location')
    op.drop_table('object_tag')
    op.drop_table('publication')
    op.drop_table('theme')
    op.drop_table('creatordocument')
    op.drop_table('object_cultureethnia')
    op.drop_table('object_type')
    op.drop_table('object_customperiod')
    op.drop_table('styleperiod')
    op.drop_table('type')
    op.drop_table('customperiod')
    op.drop_table('itineranthistory')
    op.drop_table('authorlibrary')
    op.drop_table('cocreator')
    op.drop_table('object_objectgroup')
    with op.batch_alter_table('field', schema=None) as batch_op:
        batch_op.add_column(sa.Column('allowHtml', sa.Boolean(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('field', schema=None) as batch_op:
        batch_op.drop_column('allowHtml')

    op.create_table('object_objectgroup',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('objectgroup_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_objectgroup_object_id_object')),
    sa.ForeignKeyConstraint(['objectgroup_id'], ['objectgroup.id'], name=op.f('fk_object_objectgroup_objectgroup_id_objectgroup')),
    sa.PrimaryKeyConstraint('object_id', 'objectgroup_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('cocreator',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('creator_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('observation', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('role', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_cocreator_createdby_id_user')),
    sa.ForeignKeyConstraint(['creator_id'], ['creator.id'], name=op.f('fk_cocreator_creator_id_creator'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_cocreator_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_cocreator_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('authorlibrary',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('alias', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('apprenticeOf', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('authorCode', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('bornYear', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('collectiveName', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('consecated', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('country', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('deceased', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('firstname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('fullname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('gender', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('lastname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('biography', mysql.TEXT(), nullable=True),
    sa.Column('mainPicture_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('objectQty', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('observation', mysql.TEXT(), nullable=True),
    sa.Column('placeDeceased', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('placeBirth', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('disciple', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('tags', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('atelier', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('textsearch', mysql.TEXT(), nullable=True),
    sa.Column('type', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('workshop', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_authorlibrary_createdby_id_user')),
    sa.ForeignKeyConstraint(['mainPicture_id'], ['blob.id'], name=op.f('fk_authorlibrary_mainPicture_id_blob')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_authorlibrary_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('itineranthistory',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('place', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('dateStart', sa.DATE(), nullable=True),
    sa.Column('dateTill', sa.DATE(), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('relation_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_itineranthistory_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_itineranthistory_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['relation_id'], ['objectgroup.id'], name=op.f('fk_itineranthistory_relation_id_objectgroup'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('customperiod',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_customperiod_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_customperiod_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['customperiod.id'], name='fk_customperiod_parent_id_customperiod', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('type',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_type_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_type_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['type.id'], name='fk_type_parent_id_type', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('styleperiod',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('definition', mysql.TEXT(), nullable=True),
    sa.Column('gettyId', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_styleperiod_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_styleperiod_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['styleperiod.id'], name='fk_styleperiod_parent_id_styleperiod', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object_customperiod',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('customperiod_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['customperiod_id'], ['customperiod.id'], name=op.f('fk_object_customperiod_customperiod_id_customperiod')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_customperiod_object_id_object')),
    sa.PrimaryKeyConstraint('object_id', 'customperiod_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('object_type',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('type_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_type_object_id_object')),
    sa.ForeignKeyConstraint(['type_id'], ['type.id'], name=op.f('fk_object_type_type_id_type')),
    sa.PrimaryKeyConstraint('object_id', 'type_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('object_cultureethnia',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('cultureethnia_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['cultureethnia_id'], ['cultureethnia.id'], name=op.f('fk_object_cultureethnia_cultureethnia_id_cultureethnia')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_cultureethnia_object_id_object')),
    sa.PrimaryKeyConstraint('object_id', 'cultureethnia_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('creatordocument',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('title', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('author', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('link', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('date', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('subject', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('blob_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('creator_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['blob_id'], ['blob.id'], name=op.f('fk_creatordocument_blob_id_blob')),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_creatordocument_createdby_id_user')),
    sa.ForeignKeyConstraint(['creator_id'], ['creator.id'], name=op.f('fk_creatordocument_creator_id_creator'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_creatordocument_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('theme',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_theme_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_theme_modifiedby_id_user'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('publication',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('group_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_publication_createdby_id_user')),
    sa.ForeignKeyConstraint(['group_id'], ['objectgroup.id'], name=op.f('fk_publication_group_id_objectgroup'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_publication_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object_tag',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('tag_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_tag_object_id_object')),
    sa.ForeignKeyConstraint(['tag_id'], ['tag.id'], name=op.f('fk_object_tag_tag_id_tag')),
    sa.PrimaryKeyConstraint('object_id', 'tag_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('location',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('objectsQty', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('position', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_location_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_location_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['location.id'], name='fk_location_parent_id_location', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('technique',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('definition', mysql.TEXT(), nullable=True),
    sa.Column('gettyId', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_technique_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_technique_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['technique.id'], name='fk_technique_parent_id_technique', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('collectionlist',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_collectionlist_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_collectionlist_modifiedby_id_user'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('objectgroup',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('internalExternal', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('itinerant', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('type', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('typeSpecify', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('dateStart', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('dateDue', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('image_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_objectgroup_createdby_id_user')),
    sa.ForeignKeyConstraint(['image_id'], ['blob.id'], name=op.f('fk_objectgroup_image_id_blob')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_objectgroup_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('cultureethnia',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('definition', mysql.TEXT(), nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_cultureethnia_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_cultureethnia_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['parent_id'], ['cultureethnia.id'], name=op.f('fk_cultureethnia_parent_id_cultureethnia'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('locationlog',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('status', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('exhibitionRoom', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('storageNumber', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('depositShelf', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('information', mysql.TEXT(), nullable=True),
    sa.Column('fromDate', sa.DATE(), nullable=True),
    sa.Column('tillDate', sa.DATE(), nullable=True),
    sa.Column('location_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('detail', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_locationlog_createdby_id_user')),
    sa.ForeignKeyConstraint(['location_id'], ['location.id'], name=op.f('fk_locationlog_location_id_location'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_locationlog_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_locationlog_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('coAuthors', mysql.TEXT(), nullable=True),
    sa.Column('title', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('suggestedTitle', mysql.TEXT(), nullable=True),
    sa.Column('creationDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('dateEra', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('accessionNumber', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('rfid', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('lastLocation', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('numObjects', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('allMeasurements', mysql.TEXT(), nullable=True),
    sa.Column('objectType', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('methodsTechniques', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('material', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('support', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('signature', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('signatureLocation', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('distinctiveFeatures', mysql.TEXT(), nullable=True),
    sa.Column('inscriptions', mysql.TEXT(), nullable=True),
    sa.Column('observations', mysql.TEXT(), nullable=True),
    sa.Column('process', mysql.TEXT(), nullable=True),
    sa.Column('iconographicDescription', mysql.TEXT(), nullable=True),
    sa.Column('references', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('specify', mysql.TEXT(), nullable=True),
    sa.Column('approximateDate', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('noDate', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('cultureSpecify', mysql.TEXT(), nullable=True),
    sa.Column('useFunction', mysql.TEXT(), nullable=True),
    sa.Column('unknownOrigin', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('countryOrigin', mysql.TEXT(), nullable=True),
    sa.Column('stateProvince', mysql.TEXT(), nullable=True),
    sa.Column('locality', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('specificPlace', mysql.TEXT(), nullable=True),
    sa.Column('contextObservations', mysql.TEXT(), nullable=True),
    sa.Column('groupType', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('groupName', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('numComponents', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('partOf', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('principalAuthorRole', mysql.TEXT(), nullable=True),
    sa.Column('anonymous', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('unknownAuthor', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('attributedToCreator', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('conservationState', mysql.TEXT(), nullable=True),
    sa.Column('temperatureSpecifications', mysql.TEXT(), nullable=True),
    sa.Column('humidityVulnerable', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('humiditySpecifications', mysql.TEXT(), nullable=True),
    sa.Column('lightVulnerable', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('lightSpecifications', mysql.TEXT(), nullable=True),
    sa.Column('conservationRecommendations', mysql.TEXT(), nullable=True),
    sa.Column('ornamentalAlteration', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('ornamentalDeterioration', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('structuralAlteration', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('structuralDeterioration', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('otherDeterioration', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('conservationInformation', mysql.TEXT(), nullable=True),
    sa.Column('gpsLocation', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('entryMethod', mysql.TEXT(), nullable=True),
    sa.Column('acquisitionDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('acquisitionHistory', mysql.TEXT(), nullable=True),
    sa.Column('provenance', mysql.TEXT(), nullable=True),
    sa.Column('acquisitionCountry', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('deaccessionDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('deaccessionMethod', mysql.TEXT(), nullable=True),
    sa.Column('deaccessionObservations', mysql.TEXT(), nullable=True),
    sa.Column('currency', mysql.TEXT(), nullable=True),
    sa.Column('purchasePrice', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('estimatedValue', mysql.BIGINT(display_width=20), autoincrement=False, nullable=True),
    sa.Column('salePrice', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('appraisalDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('appraiser', mysql.TEXT(), nullable=True),
    sa.Column('appraisalNotes', mysql.TEXT(), nullable=True),
    sa.Column('insuranceValue', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('insurerName', mysql.TEXT(), nullable=True),
    sa.Column('policyNumber', mysql.TEXT(), nullable=True),
    sa.Column('costAdmin', mysql.BIGINT(display_width=20), autoincrement=False, nullable=True),
    sa.Column('costUSDAdmin', mysql.BIGINT(display_width=20), autoincrement=False, nullable=True),
    sa.Column('annualTDC_admin', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('originAdmin', mysql.TEXT(), nullable=True),
    sa.Column('valueUSDAdmin', mysql.BIGINT(display_width=20), autoincrement=False, nullable=True),
    sa.Column('insuranceAmountAdmin', mysql.BIGINT(display_width=20), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.Column('creator_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('collection_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('featuredImage_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('category', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('insuranceResponsible', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('insuranceDateExpiration', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('theme_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('registrationStatus', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('ingressDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('registerIndex', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('typeAcquisition', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('conservationStateSpecify', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('insurancePercent', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('qtySD', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('qtyHD', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('qtyImage', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['collection_id'], ['collectionlist.id'], name='fk_object_collection_id_collectionlist', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_object_createdby_id_user'),
    sa.ForeignKeyConstraint(['creator_id'], ['creator.id'], name='fk_object_creator_id_creator', ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['featuredImage_id'], ['blob.id'], name='fk_object_featuredImage_id_blob'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_object_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['theme_id'], ['theme.id'], name='fk_object_theme_id_theme', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('documentobject',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('title', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('author', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('subject', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('date', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('blob_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('link', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['blob_id'], ['blob.id'], name=op.f('fk_documentobject_blob_id_blob')),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_documentobject_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_documentobject_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_documentobject_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object_styleperiod',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('styleperiod_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_styleperiod_object_id_object')),
    sa.ForeignKeyConstraint(['styleperiod_id'], ['styleperiod.id'], name=op.f('fk_object_styleperiod_styleperiod_id_styleperiod')),
    sa.PrimaryKeyConstraint('object_id', 'styleperiod_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('category',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('definition', mysql.TEXT(), nullable=True),
    sa.Column('gettyId', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_category_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_category_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['category.id'], name='fk_category_parent_id_category', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('material',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('definition', mysql.TEXT(), nullable=True),
    sa.Column('gettyId', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('parent_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_material_createdby_id_user'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_material_modifiedby_id_user'),
    sa.ForeignKeyConstraint(['parent_id'], ['material.id'], name='fk_material_parent_id_material', ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object_material',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('material_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['material_id'], ['material.id'], name=op.f('fk_object_material_material_id_material')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_material_object_id_object')),
    sa.PrimaryKeyConstraint('object_id', 'material_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('measurement',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('circumference', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('contour', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('depth', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('diameter', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('exactApprox', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('height', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('insideSize', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('item', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('label', mysql.TEXT(), nullable=True),
    sa.Column('length', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('other', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('outsideSize', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('size', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('thickness', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('units', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('volume', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('weight', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('weightUnit', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('width', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('withFrame', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_measurement_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_measurement_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_measurement_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('reproductionright',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('creator_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('institution', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('email', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('phone', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('relation', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('note', mysql.TEXT(), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_reproductionright_createdby_id_user')),
    sa.ForeignKeyConstraint(['creator_id'], ['creator.id'], name=op.f('fk_reproductionright_creator_id_creator'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_reproductionright_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object_category',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('category_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['category_id'], ['category.id'], name=op.f('fk_object_category_category_id_category')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_category_object_id_object')),
    sa.PrimaryKeyConstraint('object_id', 'category_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('note',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('note', mysql.TEXT(), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_note_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_note_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_note_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('creator',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('alias', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('apprenticeOf', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('authorCode', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('bornYear', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('collectiveName', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('consecated', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('country', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('deceased', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('firstname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('gender', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('lastname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('biography', mysql.TEXT(), nullable=True),
    sa.Column('mainPicture_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('observation', mysql.TEXT(), nullable=True),
    sa.Column('placeDeceased', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('placeBirth', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('disciple', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('tags', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('atelier', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('type', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('workshop', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.Column('fullname', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('objectQty', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('textsearch', mysql.TEXT(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name='fk_creator_createdby_id_user'),
    sa.ForeignKeyConstraint(['mainPicture_id'], ['blob.id'], name='fk_creator_mainPicture_id_blob'),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name='fk_creator_modifiedby_id_user'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('object_technique',
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.Column('technique_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_object_technique_object_id_object')),
    sa.ForeignKeyConstraint(['technique_id'], ['technique.id'], name=op.f('fk_object_technique_technique_id_technique')),
    sa.PrimaryKeyConstraint('object_id', 'technique_id'),
    mysql_collate='latin1_swedish_ci',
    mysql_default_charset='latin1',
    mysql_engine='InnoDB'
    )
    op.create_table('tag',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_tag_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_tag_modifiedby_id_user')),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('intervention',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('attachment_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('description', mysql.TEXT(), nullable=True),
    sa.Column('responsible', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('startDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('endDate', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('statusBeforeTreatment', mysql.TEXT(), nullable=True),
    sa.Column('attachmentAdditional_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('attachmentOther_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['attachmentAdditional_id'], ['blob.id'], name=op.f('fk_intervention_attachmentAdditional_id_blob')),
    sa.ForeignKeyConstraint(['attachmentOther_id'], ['blob.id'], name=op.f('fk_intervention_attachmentOther_id_blob')),
    sa.ForeignKeyConstraint(['attachment_id'], ['blob.id'], name=op.f('fk_intervention_attachment_id_blob')),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_intervention_createdby_id_user')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_intervention_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_intervention_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    op.create_table('image',
    sa.Column('id', mysql.INTEGER(display_width=11), autoincrement=True, nullable=False),
    sa.Column('additionalInformation', mysql.TEXT(), nullable=True),
    sa.Column('caption', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('highDefinition', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('image_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('object_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('position', mysql.VARCHAR(length=255), nullable=True),
    sa.Column('public', mysql.TINYINT(display_width=1), autoincrement=False, nullable=True),
    sa.Column('createdby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('modifiedby_id', mysql.INTEGER(display_width=11), autoincrement=False, nullable=True),
    sa.Column('created_at', mysql.DATETIME(), nullable=True),
    sa.Column('updated_at', mysql.DATETIME(), nullable=True),
    sa.ForeignKeyConstraint(['createdby_id'], ['user.id'], name=op.f('fk_image_createdby_id_user')),
    sa.ForeignKeyConstraint(['image_id'], ['blob.id'], name=op.f('fk_image_image_id_blob')),
    sa.ForeignKeyConstraint(['modifiedby_id'], ['user.id'], name=op.f('fk_image_modifiedby_id_user')),
    sa.ForeignKeyConstraint(['object_id'], ['object.id'], name=op.f('fk_image_object_id_object'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('id'),
    mysql_collate='utf8mb4_unicode_ci',
    mysql_default_charset='utf8mb4',
    mysql_engine='InnoDB'
    )
    # ### end Alembic commands ###
