# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Authorlibrary(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'authorlibrary'
    id = db.Column(db.Integer, primary_key=True)
    alias = db.Column(db.String(255))
    apprenticeOf = db.Column(db.String(255))
    authorCode = db.Column(db.String(255))
    bornYear = db.Column(db.Integer())
    collectiveName = db.Column(db.String(255))
    consecated = db.Column(db.Boolean())
    country = db.Column(db.String(255))
    deceased = db.Column(db.Integer())
    firstname = db.Column(db.String(255))
    fullname = db.Column(db.String(255))
    gender = db.Column(db.String(255))
    lastname = db.Column(db.String(255))
    biography = db.Column(db.Text())
    mainPicture_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    mainPicture = db.relationship('Blob', foreign_keys=[mainPicture_id], lazy='joined')
    name = db.Column(db.String(255))
    objectQty = db.Column(db.Integer())
    observation = db.Column(db.Text())
    placeDeceased = db.Column(db.String(255))
    placeBirth = db.Column(db.String(255))
    disciple = db.Column(db.String(255))
    tags = db.Column(db.String(255))
    atelier = db.Column(db.String(255))
    textsearch = db.Column(db.Text())
    type = db.Column(db.String(255))
    workshop = db.Column(db.String(255))
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_authorsLibrary', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_authorsLibrary', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))

    def helper_fullname(self):
        from project.scripts.creator import fullname
        result = fullname(self)
        self.fullname = result
        try:
            db.session.add(self) 
            db.session.commit() 
        except Exception as e:
            db.session.rollback()
            raise 
        return self.fullname
    def helper_objectQty(self):
        from project.scripts.creator import objectQty
        result = objectQty(self)
        self.objectQty = result
        try:
            db.session.add(self) 
            db.session.commit() 
        except Exception as e:
            db.session.rollback()
            raise 
        return self.objectQty
    def helper_textsearch(self):
        from project.scripts.creator import textsearch
        result = textsearch(self)
        self.textsearch = result
        try:
            db.session.add(self) 
            db.session.commit() 
        except Exception as e:
            db.session.rollback()
            raise 
        return self.textsearch

    @hybrid_property
    def full_repr(self):
        result = f'''{self.fullname if self.fullname is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.fullname, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [full_repr]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'alias': {'id': 313, 'type': 'String', 'name': 'alias', 'maxlength': None, 'connected_table': None, 'label': 'Alias', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'apprenticeOf': {'id': 314, 'type': 'String', 'name': 'apprenticeOf', 'maxlength': None, 'connected_table': None, 'label': 'Aprendiz de', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'authorCode': {'id': 315, 'type': 'String', 'name': 'authorCode', 'maxlength': None, 'connected_table': None, 'label': 'Código de Autor', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'bornYear': {'id': 316, 'type': 'Integer', 'name': 'bornYear', 'maxlength': 4, 'connected_table': None, 'label': 'Año de Nacimiento', 'input': 'number', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'collectiveName': {'id': 317, 'type': 'String', 'name': 'collectiveName', 'maxlength': None, 'connected_table': None, 'label': 'Nombre del Colectivo', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'consecated': {'id': 318, 'type': 'Boolean', 'name': 'consecated', 'maxlength': None, 'connected_table': None, 'label': 'Consagrado', 'input': 'boolean', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'country': {'id': 319, 'type': 'String', 'name': 'country', 'maxlength': None, 'connected_table': None, 'label': 'País', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{\r\n    "Afganistán": "AF",\r\n    "Albania": "AL",\r\n    "Alemania": "DE",\r\n    "Andorra": "AD",\r\n    "Angola": "AO",\r\n    "Anguila": "AI",\r\n    "Antártida": "AQ",\r\n    "Antigua y Barbuda": "AG",\r\n    "Arabia Saudita": "SA",\r\n    "Argelia": "DZ",\r\n    "Argentina": "AR",\r\n    "Armenia": "AM",\r\n    "Aruba": "AW",\r\n    "Australia": "AU",\r\n    "Austria": "AT",\r\n    "Azerbaiyán": "AZ",\r\n    "Bahamas": "BS",\r\n    "Bahréin": "BH",\r\n    "Bangladés": "BD",\r\n    "Barbados": "BB",\r\n    "Bélgica": "BE",\r\n    "Belice": "BZ",\r\n    "Benín": "BJ",\r\n    "Bermudas": "BM",\r\n    "Bielorrusia": "BY",\r\n    "Birmania (Myanmar)": "MM",\r\n    "Bolivia": "BO",\r\n    "Bonaire, San Eustaquio y Saba": "BQ",\r\n    "Bosnia y Herzegovina": "BA",\r\n    "Botsuana": "BW",\r\n    "Brasil": "BR",\r\n    "Brunéi": "BN",\r\n    "Bulgaria": "BG",\r\n    "Burkina Faso": "BF",\r\n    "Burundi": "BI",\r\n    "Bután": "BT",\r\n    "Cabo Verde": "CV",\r\n    "Camboya": "KH",\r\n    "Camerún": "CM",\r\n    "Canadá": "CA",\r\n    "Catar": "QA",\r\n    "Chad": "TD",\r\n    "Chile": "CL",\r\n    "China": "CN",\r\n    "Chipre": "CY",\r\n    "Ciudad del Vaticano": "VA",\r\n    "Colombia": "CO",\r\n    "Comoras": "KM",\r\n    "Congo (Brazzaville)": "CG",\r\n    "Congo (Kinshasa)": "CD",\r\n    "Corea del Norte": "KP",\r\n    "Corea del Sur": "KR",\r\n    "Costa de Marfil": "CI",\r\n    "Costa Rica": "CR",\r\n    "Croacia": "HR",\r\n    "Cuba": "CU",\r\n    "Curazao": "CW",\r\n    "Dinamarca": "DK",\r\n    "Dominica": "DM",\r\n    "Ecuador": "EC",\r\n    "Egipto": "EG",\r\n    "El Salvador": "SV",\r\n    "Emiratos Árabes Unidos": "AE",\r\n    "Eritrea": "ER",\r\n    "Eslovaquia": "SK",\r\n    "Eslovenia": "SI",\r\n    "España": "ES",\r\n    "Estados Unidos": "US",\r\n    "Estonia": "EE",\r\n    "Esuatini": "SZ",\r\n    "Etiopía": "ET",\r\n    "Filipinas": "PH",\r\n    "Finlandia": "FI",\r\n    "Fiyi": "FJ",\r\n    "Francia": "FR",\r\n    "Gabón": "GA",\r\n    "Gambia": "GM",\r\n    "Georgia": "GE",\r\n    "Ghana": "GH",\r\n    "Gibraltar": "GI",\r\n    "Granada": "GD",\r\n    "Grecia": "GR",\r\n    "Groenlandia": "GL",\r\n    "Guadalupe": "GP",\r\n    "Guam": "GU",\r\n    "Guatemala": "GT",\r\n    "Guayana Francesa": "GF",\r\n    "Guernsey": "GG",\r\n    "Guinea": "GN",\r\n    "Guinea Ecuatorial": "GQ",\r\n    "Guinea-Bisáu": "GW",\r\n    "Guyana": "GY",\r\n    "Haití": "HT",\r\n    "Honduras": "HN",\r\n    "Hong Kong": "HK",\r\n    "Hungría": "HU",\r\n    "India": "IN",\r\n    "Indonesia": "ID",\r\n    "Irán": "IR",\r\n    "Irak": "IQ",\r\n    "Irlanda": "IE",\r\n    "Islandia": "IS",\r\n    "Isla Bouvet": "BV",\r\n    "Isla de Man": "IM",\r\n    "Isla de Navidad": "CX",\r\n    "Isla Norfolk": "NF",\r\n    "Islas Caimán": "KY",\r\n    "Islas Cocos": "CC",\r\n    "Islas Cook": "CK",\r\n    "Islas Feroe": "FO",\r\n    "Islas Georgia del Sur y Sandwich del Sur": "GS",\r\n    "Islas Heard y McDonald": "HM",\r\n    "Islas Malvinas": "FK",\r\n    "Islas Marianas del Norte": "MP",\r\n    "Islas Marshall": "MH",\r\n    "Islas Salomón": "SB",\r\n    "Islas Turcas y Caicos": "TC",\r\n    "Islas Ultramarinas Menores de Estados Unidos": "UM",\r\n    "Islas Vírgenes Británicas": "VG",\r\n    "Islas Vírgenes de los Estados Unidos": "VI",\r\n    "Israel": "IL",\r\n    "Italia": "IT",\r\n    "Jamaica": "JM",\r\n    "Japón": "JP",\r\n    "Jersey": "JE",\r\n    "Jordania": "JO",\r\n    "Kazajistán": "KZ",\r\n    "Kenia": "KE",\r\n    "Kirguistán": "KG",\r\n    "Kiribati": "KI",\r\n    "Kuwait": "KW",\r\n    "Laos": "LA",\r\n    "Lesoto": "LS",\r\n    "Letonia": "LV",\r\n    "Líbano": "LB",\r\n    "Liberia": "LR",\r\n    "Libia": "LY",\r\n    "Liechtenstein": "LI",\r\n    "Lituania": "LT",\r\n    "Luxemburgo": "LU",\r\n    "Macao": "MO",\r\n    "Macedonia del Norte": "MK",\r\n    "Madagascar": "MG",\r\n    "Malasia": "MY",\r\n    "Malaui": "MW",\r\n    "Maldivas": "MV",\r\n    "Malí": "ML",\r\n    "Malta": "MT",\r\n    "Marruecos": "MA",\r\n    "Martinica": "MQ",\r\n    "Mauricio": "MU",\r\n    "Mauritania": "MR",\r\n    "Mayotte": "YT",\r\n    "México": "MX",\r\n    "Micronesia": "FM",\r\n    "Moldavia": "MD",\r\n    "Mónaco": "MC",\r\n    "Mongolia": "MN",\r\n    "Montenegro": "ME",\r\n    "Montserrat": "MS",\r\n    "Mozambique": "MZ",\r\n    "Namibia": "NA",\r\n    "Nauru": "NR",\r\n    "Nepal": "NP",\r\n    "Nicaragua": "NI",\r\n    "Níger": "NE",\r\n    "Nigeria": "NG",\r\n    "Niue": "NU",\r\n    "Noruega": "NO",\r\n    "Nueva Caledonia": "NC",\r\n    "Nueva Zelanda": "NZ",\r\n    "Omán": "OM",\r\n    "Países Bajos": "NL",\r\n    "Pakistán": "PK",\r\n    "Palaos": "PW",\r\n    "Palestina": "PS",\r\n    "Panamá": "PA",\r\n    "Papúa Nueva Guinea": "PG",\r\n    "Paraguay": "PY",\r\n    "Perú": "PE",\r\n    "Pitcairn": "PN",\r\n    "Polinesia Francesa": "PF",\r\n    "Polonia": "PL",\r\n    "Portugal": "PT",\r\n    "Puerto Rico": "PR",\r\n    "Reino Unido": "GB",\r\n    "República Centroafricana": "CF",\r\n    "República Checa": "CZ",\r\n    "República Dominicana": "DO",\r\n    "Reunión": "RE",\r\n    "Ruanda": "RW",\r\n    "Rumania": "RO",\r\n    "Rusia": "RU",\r\n    "Sáhara Occidental": "EH",\r\n    "Samoa": "WS",\r\n    "Samoa Americana": "AS",\r\n    "San Bartolomé": "BL",\r\n    "San Cristóbal y Nieves": "KN",\r\n    "San Martín (parte francesa)": "MF",\r\n    "San Martín (parte neerlandesa)": "SX",\r\n    "San Marino": "SM",\r\n    "San Pedro y Miquelón": "PM",\r\n    "San Vicente y las Granadas": "VC",\r\n    "Santa Helena, Ascensión y Tristán de Acuña": "SH",\r\n    "Santa Lucía": "LC",\r\n    "Santo Tomé y Príncipe": "ST",\r\n    "Senegal": "SN",\r\n    "Serbia": "RS",\r\n    "Seychelles": "SC",\r\n    "Sierra Leona": "SL",\r\n    "Singapur": "SG",\r\n    "Siria": "SY",\r\n    "Somalia": "SO",\r\n    "Sri Lanka": "LK",\r\n    "Sudáfrica": "ZA",\r\n    "Sudán": "SD",\r\n    "Sudán del Sur": "SS",\r\n    "Suecia": "SE",\r\n    "Suiza": "CH",\r\n    "Surinam": "SR",\r\n    "Svalbard y Jan Mayen": "SJ",\r\n    "Taiwán": "TW",\r\n    "Tailandia": "TH",\r\n    "Tanzania": "TZ",\r\n    "Tayikistán": "TJ",\r\n    "Territorio Británico del Océano Índico": "IO",\r\n    "Territorios Franceses del Sur": "TF",\r\n    "Timor Oriental": "TL",\r\n    "Togo": "TG",\r\n    "Tokelau": "TK",\r\n    "Tonga": "TO",\r\n    "Trinidad y Tobago": "TT",\r\n    "Túnez": "TN",\r\n    "Turkmenistán": "TM",\r\n    "Turquía": "TR",\r\n    "Tuvalu": "TV",\r\n    "Ucrania": "UA",\r\n    "Uganda": "UG",\r\n    "Uruguay": "UY",\r\n    "Uzbekistán": "UZ",\r\n    "Vanuatu": "VU",\r\n    "Venezuela": "VE",\r\n    "Vietnam": "VN",\r\n    "Wallis y Futuna": "WF",\r\n    "Yemen": "YE",\r\n    "Yibuti": "DJ",\r\n    "Zambia": "ZM",\r\n    "Zimbabue": "ZW"\r\n}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'deceased': {'id': 320, 'type': 'Integer', 'name': 'deceased', 'maxlength': 4, 'connected_table': None, 'label': 'Deceso (Año)', 'input': 'number', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'firstname': {'id': 321, 'type': 'String', 'name': 'firstname', 'maxlength': None, 'connected_table': None, 'label': 'Primer Nombre', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'fullname': {'id': 322, 'type': 'String', 'name': 'fullname', 'maxlength': None, 'connected_table': None, 'label': 'Nombre Completo', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': 'creator', 'calculate_function': 'fullname', 'helper': 'script'}, 'gender': {'id': 323, 'type': 'String', 'name': 'gender', 'maxlength': None, 'connected_table': None, 'label': 'Género', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': '4', 'select_options': '{\r\n    "Masculino": "1",\r\n    "Femenino": "2",\r\n    "NB": "3",\r\n    "No especificado": "4"\r\n}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'lastname': {'id': 324, 'type': 'String', 'name': 'lastname', 'maxlength': None, 'connected_table': None, 'label': 'Apellido', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'biography': {'id': 325, 'type': 'Text', 'name': 'biography', 'maxlength': None, 'connected_table': None, 'label': 'Biografía', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'mainPicture': {'id': 326, 'type': 'blob', 'name': 'mainPicture', 'maxlength': None, 'connected_table': None, 'label': 'Imagen Principal', 'input': 'image', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'name': {'id': 327, 'type': 'String', 'name': 'name', 'maxlength': None, 'connected_table': None, 'label': 'Nombre', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'objectQty': {'id': 328, 'type': 'Integer', 'name': 'objectQty', 'maxlength': None, 'connected_table': None, 'label': 'Cantidad de Objetos', 'input': 'number', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': 'creator', 'calculate_function': 'objectQty', 'helper': 'script'}, 'observation': {'id': 329, 'type': 'Text', 'name': 'observation', 'maxlength': None, 'connected_table': None, 'label': 'Observaciones', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'placeDeceased': {'id': 330, 'type': 'String', 'name': 'placeDeceased', 'maxlength': None, 'connected_table': None, 'label': 'Lugar de Deceso', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'placeBirth': {'id': 331, 'type': 'String', 'name': 'placeBirth', 'maxlength': None, 'connected_table': None, 'label': 'Lugar de Nacimiento', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'disciple': {'id': 332, 'type': 'String', 'name': 'disciple', 'maxlength': None, 'connected_table': None, 'label': 'Seguidor de', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'tags': {'id': 333, 'type': 'String', 'name': 'tags', 'maxlength': None, 'connected_table': None, 'label': 'Etiquetas', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'atelier': {'id': 334, 'type': 'String', 'name': 'atelier', 'maxlength': None, 'connected_table': None, 'label': 'Taller de', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'textsearch': {'id': 335, 'type': 'Text', 'name': 'textsearch', 'maxlength': None, 'connected_table': None, 'label': 'Búsqueda General', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': 'creator', 'calculate_function': 'textsearch', 'helper': 'script'}, 'type': {'id': 336, 'type': 'String', 'name': 'type', 'maxlength': None, 'connected_table': None, 'label': 'Tipo de Creador / Autor', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{\r\n    "Persona": "1",\r\n    "Colectivo / Taller / Compañía / Empresa": "2"\r\n}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'workshop': {'id': 337, 'type': 'String', 'name': 'workshop', 'maxlength': None, 'connected_table': None, 'label': 'Taller / Estudio', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
