# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Cocreator(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'cocreator'
    id = db.Column(db.Integer, primary_key=True)
    creator_id = db.Column(db.Integer, db.ForeignKey('creator.id', ondelete='SET NULL'), nullable=True)
    creator = db.relationship('Creator', foreign_keys=[creator_id], backref=backref('cocreators', order_by='Cocreator.creator_id',passive_deletes=True))
    object_id = db.Column(db.Integer, db.ForeignKey('object.id', ondelete='SET NULL'), nullable=True)
    object = db.relationship('Object', foreign_keys=[object_id], backref=backref('cocreators', order_by='Cocreator.creator_id',passive_deletes=True))
    observation = db.Column(db.String(255))
    role = db.Column(db.String(255))
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_cocreators', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_cocreators', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.creator if self.creator is not None else ''} ({self.role if self.role is not None else ''})'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.creator, literal_column("''"))  + literal_column("' '") + literal_column("'('")  + func.coalesce(cls.role, literal_column("''"))  + literal_column("')'")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [creator_id]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'creator': {'id': 172, 'type': 'connected_table', 'name': 'creator', 'maxlength': None, 'connected_table': 14, 'label': 'Cocreador / Coautor', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'object': {'id': 173, 'type': 'connected_table', 'name': 'object', 'maxlength': None, 'connected_table': 1, 'label': 'Objeto', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': True, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'observation': {'id': 174, 'type': 'String', 'name': 'observation', 'maxlength': None, 'connected_table': None, 'label': 'Observación', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'role': {'id': 175, 'type': 'String', 'name': 'role', 'maxlength': None, 'connected_table': None, 'label': 'Rol', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{"Creador / Author":"a",\r\n"Coautor":"j",\r\n"Cocreador":"b",\r\n"Grabador":"c",\r\n"Productor":"d",\r\n"Investigador":"e",\r\n"Manufacturador / Fabricante":"f",\r\n"Pintor":"g",\r\n"Impresor":"i"}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
