# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Documentobject(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'documentobject'
    id = db.Column(db.Integer, primary_key=True)
    title = db.Column(db.String(255))
    author = db.Column(db.String(255))
    subject = db.Column(db.String(255))
    date = db.Column(db.String(255))
    description = db.Column(db.Text())
    blob_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    blob = db.relationship('Blob', foreign_keys=[blob_id], lazy='joined')
    link = db.Column(db.String(255))
    object_id = db.Column(db.Integer, db.ForeignKey('object.id', ondelete='SET NULL'), nullable=True)
    object = db.relationship('Object', foreign_keys=[object_id], backref=backref('documentobjects', order_by='Documentobject.title',passive_deletes=True))
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_documentobjects', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_documentobjects', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''Adjunto: {self.title if self.title is not None else ''} - ({self.object if self.object is not None else ''})'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("'Adjunto: '")  + func.coalesce(cls.title, literal_column("''"))  + literal_column("' -'") + literal_column("' ('")  + func.coalesce(cls.object, literal_column("''"))  + literal_column("')'")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [title]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'title': {'id': 176, 'type': 'String', 'name': 'title', 'maxlength': None, 'connected_table': None, 'label': 'Título', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'author': {'id': 177, 'type': 'String', 'name': 'author', 'maxlength': None, 'connected_table': None, 'label': 'Autor / Creador', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'subject': {'id': 178, 'type': 'String', 'name': 'subject', 'maxlength': None, 'connected_table': None, 'label': 'Asunto', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{"1","Seguro",\r\n"10","Documentación",\r\n"11","Condición",\r\n"12","Bibliografía",\r\n"13","Catálogo",\r\n"14","Libro / Revista",\r\n"15","Nota de prensa",\r\n"16","Desaccesión",\r\n"19","Sonido / Audioguía",\r\n"2","Avalúo",\r\n"3","Conservación",\r\n"4","Adquisición",\r\n"5","Préstamo",\r\n"6","Proveniencia",\r\n"7","Pérdida / Robo",\r\n"8","Derechos de Autor",\r\n"9","Excavación"}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'date': {'id': 179, 'type': 'String', 'name': 'date', 'maxlength': None, 'connected_table': None, 'label': 'Fecha', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'description': {'id': 180, 'type': 'Text', 'name': 'description', 'maxlength': None, 'connected_table': None, 'label': 'Descripción', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'blob': {'id': 181, 'type': 'blob', 'name': 'blob', 'maxlength': None, 'connected_table': None, 'label': 'Archivo adjunto', 'input': 'blob', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'link': {'id': 182, 'type': 'String', 'name': 'link', 'maxlength': None, 'connected_table': None, 'label': 'Enlace', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'object': {'id': 183, 'type': 'connected_table', 'name': 'object', 'maxlength': None, 'connected_table': 1, 'label': 'Objeto', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': True, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
