# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Image(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'image'
    id = db.Column(db.Integer, primary_key=True)
    additionalInformation = db.Column(db.Text())
    caption = db.Column(db.String(255))
    highDefinition = db.Column(db.Boolean())
    image_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    image = db.relationship('Blob', foreign_keys=[image_id], lazy='joined')
    object_id = db.Column(db.Integer, db.ForeignKey('object.id', ondelete='SET NULL'), nullable=True)
    object = db.relationship('Object', foreign_keys=[object_id], backref=backref('images', order_by='Image.position',passive_deletes=True))
    position = db.Column(db.String(255))
    public = db.Column(db.Boolean())
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_images', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_images', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.caption if self.caption is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.caption, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [position]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'additionalInformation': {'id': 118, 'type': 'Text', 'name': 'additionalInformation', 'maxlength': None, 'connected_table': None, 'label': 'Información Adicional', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'caption': {'id': 119, 'type': 'String', 'name': 'caption', 'maxlength': None, 'connected_table': None, 'label': 'Pie de Imagen', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'highDefinition': {'id': 120, 'type': 'Boolean', 'name': 'highDefinition', 'maxlength': None, 'connected_table': None, 'label': 'HD', 'input': 'boolean', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'image': {'id': 121, 'type': 'blob', 'name': 'image', 'maxlength': None, 'connected_table': None, 'label': 'Imagen', 'input': 'image', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'object': {'id': 122, 'type': 'connected_table', 'name': 'object', 'maxlength': None, 'connected_table': 1, 'label': 'Objeto', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': True, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'position': {'id': 123, 'type': 'String', 'name': 'position', 'maxlength': None, 'connected_table': None, 'label': 'Ordenar', 'input': 'float', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'public': {'id': 124, 'type': 'Boolean', 'name': 'public', 'maxlength': None, 'connected_table': None, 'label': 'Hacer pública', 'input': 'boolean', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
