# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Intervention(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'intervention'
    id = db.Column(db.Integer, primary_key=True)
    attachment_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    attachment = db.relationship('Blob', foreign_keys=[attachment_id], lazy='joined')
    description = db.Column(db.Text())
    responsible = db.Column(db.String(255))
    startDate = db.Column(db.String(255))
    endDate = db.Column(db.String(255))
    statusBeforeTreatment = db.Column(db.Text())
    attachmentAdditional_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    attachmentAdditional = db.relationship('Blob', foreign_keys=[attachmentAdditional_id], lazy='joined')
    attachmentOther_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    attachmentOther = db.relationship('Blob', foreign_keys=[attachmentOther_id], lazy='joined')
    object_id = db.Column(db.Integer, db.ForeignKey('object.id', ondelete='SET NULL'), nullable=True)
    object = db.relationship('Object', foreign_keys=[object_id], backref=backref('interventions', order_by='Intervention.startDate',passive_deletes=True))
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_interventions', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_interventions', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''Fecha: {self.startDate if self.startDate is not None else ''}Objeto: {self.object if self.object is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("'Fecha: '")  + func.coalesce(cls.startDate, literal_column("''"))  + literal_column("''") + literal_column("'Objeto: '")  + func.coalesce(cls.object, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [startDate]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'attachment': {'id': 184, 'type': 'blob', 'name': 'attachment', 'maxlength': None, 'connected_table': None, 'label': 'Archivo adjunto', 'input': 'blob', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'description': {'id': 190, 'type': 'Text', 'name': 'description', 'maxlength': None, 'connected_table': None, 'label': 'Descripción', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'responsible': {'id': 186, 'type': 'String', 'name': 'responsible', 'maxlength': None, 'connected_table': None, 'label': 'Responsable', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'startDate': {'id': 187, 'type': 'String', 'name': 'startDate', 'maxlength': None, 'connected_table': None, 'label': 'Fecha de Inicio', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'endDate': {'id': 188, 'type': 'String', 'name': 'endDate', 'maxlength': None, 'connected_table': None, 'label': 'Fecha de Salida', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'statusBeforeTreatment': {'id': 189, 'type': 'Text', 'name': 'statusBeforeTreatment', 'maxlength': None, 'connected_table': None, 'label': 'Descripción antes del tratamiento', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'attachmentAdditional': {'id': 191, 'type': 'blob', 'name': 'attachmentAdditional', 'maxlength': None, 'connected_table': None, 'label': 'Archivo adjunto (adicional)', 'input': 'blob', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'attachmentOther': {'id': 192, 'type': 'blob', 'name': 'attachmentOther', 'maxlength': None, 'connected_table': None, 'label': 'Archivo adjunto (otros)', 'input': 'blob', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'object': {'id': 193, 'type': 'connected_table', 'name': 'object', 'maxlength': None, 'connected_table': 1, 'label': 'Objeto', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': True, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
