# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Itineranthistory(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'itineranthistory'
    id = db.Column(db.Integer, primary_key=True)
    place = db.Column(db.String(255))
    dateStart = db.Column(db.Date())
    dateTill = db.Column(db.Date())
    description = db.Column(db.Text())
    relation_id = db.Column(db.Integer, db.ForeignKey('objectgroup.id', ondelete='SET NULL'), nullable=True)
    relation = db.relationship('Objectgroup', foreign_keys=[relation_id], backref=backref('itineranthistorial', order_by='Itineranthistory.place',passive_deletes=True))
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_itineranthistorial', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_itineranthistorial', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.place if self.place is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.place, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [place]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'place': {'id': 216, 'type': 'String', 'name': 'place', 'maxlength': None, 'connected_table': None, 'label': 'Lugar', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'dateStart': {'id': 217, 'type': 'Date', 'name': 'dateStart', 'maxlength': None, 'connected_table': None, 'label': 'Desde', 'input': 'date', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'dateTill': {'id': 218, 'type': 'Date', 'name': 'dateTill', 'maxlength': None, 'connected_table': None, 'label': 'Hasta', 'input': 'date', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'description': {'id': 219, 'type': 'Text', 'name': 'description', 'maxlength': None, 'connected_table': None, 'label': 'Descripción', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'relation': {'id': 220, 'type': 'connected_table', 'name': 'relation', 'maxlength': None, 'connected_table': 21, 'label': 'group', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': True, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': True, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
