# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Locationlog(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'locationlog'
    id = db.Column(db.Integer, primary_key=True)
    status = db.Column(db.String(255))
    exhibitionRoom = db.Column(db.String(255))
    storageNumber = db.Column(db.String(255))
    depositShelf = db.Column(db.String(255))
    information = db.Column(db.Text())
    fromDate = db.Column(db.Date())
    tillDate = db.Column(db.Date())
    location_id = db.Column(db.Integer, db.ForeignKey('location.id', ondelete='SET NULL'), nullable=True)
    location = db.relationship('Location', foreign_keys=[location_id], backref=backref('locationlogs', order_by=lambda: desc(Locationlog.fromDate),passive_deletes=True))
    detail = db.Column(db.String(255))
    object_id = db.Column(db.Integer, db.ForeignKey('object.id', ondelete='SET NULL'), nullable=True)
    object = db.relationship('Object', foreign_keys=[object_id], backref=backref('locationlogs', order_by=lambda: desc(Locationlog.fromDate),passive_deletes=True))
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_locationlogs', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_locationlogs', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.location if self.location is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.location, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [desc('fromDate')]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'status': {'id': 198, 'type': 'String', 'name': 'status', 'maxlength': None, 'connected_table': None, 'label': 'Estado', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{"En almacenamiento":"a",\r\n"En exhibición temporal":"b",\r\n"Vendido":"c",\r\n"En laboratorio":"d",\r\n"En préstamo":"e",\r\n"En exhibición permanente":"f"}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'exhibitionRoom': {'id': 199, 'type': 'String', 'name': 'exhibitionRoom', 'maxlength': None, 'connected_table': None, 'label': 'Sala de exhibición', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'storageNumber': {'id': 200, 'type': 'String', 'name': 'storageNumber', 'maxlength': None, 'connected_table': None, 'label': 'Número de almacenamiento', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'depositShelf': {'id': 201, 'type': 'String', 'name': 'depositShelf', 'maxlength': None, 'connected_table': None, 'label': 'Estante', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'information': {'id': 202, 'type': 'Text', 'name': 'information', 'maxlength': None, 'connected_table': None, 'label': 'Información', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'fromDate': {'id': 203, 'type': 'Date', 'name': 'fromDate', 'maxlength': None, 'connected_table': None, 'label': 'De', 'input': 'date', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'tillDate': {'id': 204, 'type': 'Date', 'name': 'tillDate', 'maxlength': None, 'connected_table': None, 'label': 'Hasta', 'input': 'date', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'location': {'id': 205, 'type': 'connected_table', 'name': 'location', 'maxlength': None, 'connected_table': 18, 'label': 'Ubicación', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'detail': {'id': 206, 'type': 'String', 'name': 'detail', 'maxlength': None, 'connected_table': None, 'label': 'Detalle', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'object': {'id': 252, 'type': 'connected_table', 'name': 'object', 'maxlength': None, 'connected_table': 1, 'label': 'Objeto', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': True, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
