# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Measurement(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'measurement'
    id = db.Column(db.Integer, primary_key=True)
    circumference = db.Column(db.String(255))
    contour = db.Column(db.String(255))
    depth = db.Column(db.String(255))
    diameter = db.Column(db.String(255))
    exactApprox = db.Column(db.String(255))
    height = db.Column(db.String(255))
    insideSize = db.Column(db.String(255))
    item = db.Column(db.String(255))
    label = db.Column(db.Text())
    length = db.Column(db.String(255))
    object_id = db.Column(db.Integer, db.ForeignKey('object.id', ondelete='SET NULL'), nullable=True)
    object = db.relationship('Object', foreign_keys=[object_id], backref=backref('measurements', order_by=lambda: desc(Measurement.id),passive_deletes=True))
    other = db.Column(db.String(255))
    outsideSize = db.Column(db.String(255))
    size = db.Column(db.String(255))
    thickness = db.Column(db.String(255))
    units = db.Column(db.String(255))
    volume = db.Column(db.String(255))
    weight = db.Column(db.String(255))
    weightUnit = db.Column(db.String(255))
    width = db.Column(db.String(255))
    withFrame = db.Column(db.Boolean())
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_measurements', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_measurements', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.id if self.id is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.id, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [desc('id')]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'circumference': {'id': 97, 'type': 'String', 'name': 'circumference', 'maxlength': None, 'connected_table': None, 'label': 'Circunferencia', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'contour': {'id': 98, 'type': 'String', 'name': 'contour', 'maxlength': None, 'connected_table': None, 'label': 'Contorno', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'depth': {'id': 99, 'type': 'String', 'name': 'depth', 'maxlength': None, 'connected_table': None, 'label': 'Profundidad', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'diameter': {'id': 100, 'type': 'String', 'name': 'diameter', 'maxlength': None, 'connected_table': None, 'label': 'Diámetro', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'exactApprox': {'id': 101, 'type': 'String', 'name': 'exactApprox', 'maxlength': None, 'connected_table': None, 'label': 'Exacto / Aproximado', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{ "Aproximado": "1","Exacto":"2"}', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'height': {'id': 102, 'type': 'String', 'name': 'height', 'maxlength': None, 'connected_table': None, 'label': 'Altura', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'insideSize': {'id': 103, 'type': 'String', 'name': 'insideSize', 'maxlength': None, 'connected_table': None, 'label': 'Parte interna', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'item': {'id': 104, 'type': 'String', 'name': 'item', 'maxlength': None, 'connected_table': None, 'label': 'Item', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'label': {'id': 105, 'type': 'Text', 'name': 'label', 'maxlength': None, 'connected_table': None, 'label': 'Resumen', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'length': {'id': 106, 'type': 'String', 'name': 'length', 'maxlength': None, 'connected_table': None, 'label': 'Largo', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'object': {'id': 107, 'type': 'connected_table', 'name': 'object', 'maxlength': None, 'connected_table': 1, 'label': 'Object', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': True, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'other': {'id': 108, 'type': 'String', 'name': 'other', 'maxlength': None, 'connected_table': None, 'label': 'Otro', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'outsideSize': {'id': 109, 'type': 'String', 'name': 'outsideSize', 'maxlength': None, 'connected_table': None, 'label': 'Parte externa', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'size': {'id': 110, 'type': 'String', 'name': 'size', 'maxlength': None, 'connected_table': None, 'label': 'Tamaño', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'thickness': {'id': 111, 'type': 'String', 'name': 'thickness', 'maxlength': None, 'connected_table': None, 'label': 'Grosor', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'units': {'id': 112, 'type': 'String', 'name': 'units', 'maxlength': None, 'connected_table': None, 'label': 'Unidades', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{"Metros":"1","Centímetros":"2","Milímetros":"3","Pulgadas":"4"}', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'volume': {'id': 113, 'type': 'String', 'name': 'volume', 'maxlength': None, 'connected_table': None, 'label': 'Volumen', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'weight': {'id': 114, 'type': 'String', 'name': 'weight', 'maxlength': None, 'connected_table': None, 'label': 'Peso', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'weightUnit': {'id': 115, 'type': 'String', 'name': 'weightUnit', 'maxlength': None, 'connected_table': None, 'label': 'Unidad de peso', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{"Gramos":"1","Kilogramos":"2","Libra":"3","Quilates":"4","Onzas":"5"}', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'width': {'id': 116, 'type': 'String', 'name': 'width', 'maxlength': None, 'connected_table': None, 'label': 'Ancho', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'withFrame': {'id': 117, 'type': 'Boolean', 'name': 'withFrame', 'maxlength': None, 'connected_table': None, 'label': 'Con marco', 'input': 'boolean', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '', 'extraclass': '', 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
