# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Objectgroup(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'objectgroup'
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(255))
    internalExternal = db.Column(db.String(255))
    itinerant = db.Column(db.Boolean())
    type = db.Column(db.String(255))
    typeSpecify = db.Column(db.String(255))
    description = db.Column(db.Text())
    dateStart = db.Column(db.String(255))
    dateDue = db.Column(db.String(255))
    image_id = db.Column(db.Integer, db.ForeignKey('blob.id'), nullable=True)
    image = db.relationship('Blob', foreign_keys=[image_id], lazy='joined')
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_objectgroups', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_objectgroups', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.name if self.name is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.name, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [name]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'name': {'id': 211, 'type': 'String', 'name': 'name', 'maxlength': None, 'connected_table': None, 'label': 'Nombre', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'internalExternal': {'id': 212, 'type': 'String', 'name': 'internalExternal', 'maxlength': None, 'connected_table': None, 'label': 'Exposición Interna o Externa', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{"Interna":"1",\r\n"Externa":"2"}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'itinerant': {'id': 213, 'type': 'Boolean', 'name': 'itinerant', 'maxlength': None, 'connected_table': None, 'label': 'Es itinerante', 'input': 'boolean', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'type': {'id': 214, 'type': 'String', 'name': 'type', 'maxlength': None, 'connected_table': None, 'label': 'Tipo de Grupos', 'input': 'select', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': '{\r\n    "Colección":"Col",\r\n    "Obra compuesta":"Comp",\r\n    "Díptico":"Diptic",\r\n    "Exposición":"Expo",\r\n    "Grupo":"Group",\r\n    "Políptico":"Poliptic",\r\n    "Serie":"Series",\r\n    "Tríptico":"Triptic"\r\n}', 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'typeSpecify': {'id': 215, 'type': 'String', 'name': 'typeSpecify', 'maxlength': None, 'connected_table': None, 'label': 'Tipo (Especificar)', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'description': {'id': 229, 'type': 'Text', 'name': 'description', 'maxlength': None, 'connected_table': None, 'label': 'Descripción', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'dateStart': {'id': 230, 'type': 'String', 'name': 'dateStart', 'maxlength': None, 'connected_table': None, 'label': 'Fecha de Inicio', 'input': 'incompletedate', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'dateDue': {'id': 231, 'type': 'String', 'name': 'dateDue', 'maxlength': None, 'connected_table': None, 'label': 'Fecha de Finalización', 'input': 'incompletedate', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'image': {'id': 232, 'type': 'blob', 'name': 'image', 'maxlength': None, 'connected_table': None, 'label': 'Imagen Principal', 'input': 'image', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
