# -*- coding: utf-8 -*-
from core.utils.db import db
from core.utils.packages.session import BackupOnDeleteMixin
from sqlalchemy.orm import backref
from sqlalchemy import BigInteger
from datetime import datetime, timezone 
from sqlalchemy import desc, func, String, case, literal_column  
from sqlalchemy.ext.hybrid import hybrid_property 
from sqlalchemy.sql.expression import null 

class Reproductionright(db.Model, BackupOnDeleteMixin):
    __tablename__ = 'reproductionright'
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(255))
    creator_id = db.Column(db.Integer, db.ForeignKey('creator.id', ondelete='SET NULL'), nullable=True)
    creator = db.relationship('Creator', foreign_keys=[creator_id], backref=backref('reproductionrights', order_by='Reproductionright.name',passive_deletes=True))
    institution = db.Column(db.String(255))
    email = db.Column(db.String(255))
    phone = db.Column(db.String(255))
    relation = db.Column(db.String(255))
    note = db.Column(db.Text())
    createdby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    modifiedby_id = db.Column(db.Integer, db.ForeignKey('user.id'))
    createdby = db.relationship('User', backref='created_reproductionrights', foreign_keys=[createdby_id])
    modifiedby = db.relationship('User', backref='modified_reproductionrights', foreign_keys=[modifiedby_id])
    created_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = db.Column(db.DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))


    @hybrid_property
    def full_repr(self):
        result = f'''{self.name if self.name is not None else ''}- {self.creator if self.creator is not None else ''}'''
        return result.strip()

    @full_repr.expression
    def full_repr(cls):
        return (
            literal_column("") + literal_column("''")  + func.coalesce(cls.name, literal_column("''"))  + literal_column("'-'") + literal_column("' '")  + func.coalesce(cls.creator, literal_column("''"))  + literal_column("''")
        )

    def __repr__(self) -> str:
        return self.full_repr 
    __default_ordering__ = [name]

    __table_args__ = {
        "mysql_charset": "utf8mb4",
        "mysql_collate": "utf8mb4_unicode_ci",
    }


def get_fields():
    fields = {'name': {'id': 222, 'type': 'String', 'name': 'name', 'maxlength': None, 'connected_table': None, 'label': 'Nombre', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'creator': {'id': 223, 'type': 'connected_table', 'name': 'creator', 'maxlength': None, 'connected_table': 14, 'label': 'Autor / Creador', 'input': 'connected_table', 'sort': None, 'required': False, 'hidden': True, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': True, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'institution': {'id': 224, 'type': 'String', 'name': 'institution', 'maxlength': None, 'connected_table': None, 'label': 'Institución', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'email': {'id': 225, 'type': 'String', 'name': 'email', 'maxlength': None, 'connected_table': None, 'label': 'Correo electrónico', 'input': 'email', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'phone': {'id': 226, 'type': 'String', 'name': 'phone', 'maxlength': None, 'connected_table': None, 'label': 'Teléfono', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'relation': {'id': 227, 'type': 'String', 'name': 'relation', 'maxlength': None, 'connected_table': None, 'label': 'Relación', 'input': 'text', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}, 'note': {'id': 228, 'type': 'Text', 'name': 'note', 'maxlength': None, 'connected_table': None, 'label': 'Observaciones', 'input': 'textarea', 'sort': None, 'required': False, 'hidden': False, 'publicBlob': False, 'default_value': None, 'select_options': None, 'extraclass': None, 'allowHtml': False, 'hasManyValues': False, 'readOnly': False, 'calculate_file': None, 'calculate_function': None, 'helper': None}}
    return fields


def get_relevants():
    relevants = {}
    return relevants
